using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

internal class Program
{
    static int MergeSortAndCount(List<(double, double)> arr)
    {
        List<(double, double)> temp = new List<(double, double)>(arr);
        return MergeSortAndCount(arr, temp, 0, arr.Count - 1);
    }

    static int MergeSortAndCount(List<(double, double)> arr, List<(double, double)> temp, int left, int right)
    {
        int count = 0;
        if (right > left)
        {
            int mid = (right + left) / 2;
            count += MergeSortAndCount(arr, temp, left, mid);
            count += MergeSortAndCount(arr, temp, mid + 1, right);
            count += MergeAndCount(arr, temp, left, mid + 1, right);
        }
        return count;
    }

    static int MergeAndCount(List<(double, double)> arr, List<(double, double)> temp, int left, int mid, int right)
    {
        int i = left;
        int j = mid;
        int k = left;
        int inversions = 0;

        while ((i <= mid - 1) && (j <= right))
        {
            if (arr[i].Item1 < arr[j].Item1 || (arr[i].Item1 == arr[j].Item1 && arr[i].Item2 <= arr[j].Item2))
            {
                temp[k++] = arr[i++];
            }
            else
            {
                temp[k++] = arr[j++];
                inversions += (mid - i);
            }
        }

        while (i <= mid - 1)
        {
            temp[k++] = arr[i++];
        }

        while (j <= right)
        {
            temp[k++] = arr[j++];
        }

        for (i = left; i <= right; i++)
        {
            arr[i] = temp[i];
        }

        return inversions;
    }
    static void Main(string[] args)
    {
        var jeajea = Console.ReadLine().Split();        
        int n = int.Parse(jeajea[0]);
        int k = int.Parse(jeajea[1]);

        List<(double, double)> lista = new List<(double, double)>();
        for (int i = 0;i<n;i++)
        {
            jeajea = Console.ReadLine().Split();
            lista.Add((double.Parse(jeajea[0]), double.Parse(jeajea[1])));
        }

        int okidac = 0;
        double t=double.MaxValue;
        double ukupnoT=0;
        double t1;

        while(okidac<k)
        {
            for (int i = 0;i<lista.Count-1;i++) 
            {
                if (lista[i].Item2 > lista[i+1].Item2)
                {
                    t1 = (lista[i + 1].Item1 - lista[i].Item1) / (lista[i].Item2 - lista[i + 1].Item2);
                    if(t1<t)
                    {
                        t = t1;
                    }
                }
            }
            for(int i = 0; i < lista.Count; i++)
            {
                lista[i] = (lista[i].Item1 + lista[i].Item2 * t, lista[i].Item2);
            }
            okidac+=MergeSortAndCount(lista);
            ukupnoT += t;
            t = double.MaxValue;

        }
        Console.WriteLine(ukupnoT);
    }
}